#CLASES
#------------------------------------------
class World
	attr_gtk
	attr :sprites, :size, :walls, :defaults, :exit, :doors, :switches, :number_of_levels
	
	def initialize args, level
		@map_id = level
		@parse_map = args.gtk.parse_json_file "levels/world.json"
		@size = { w: @parse_map['levels'][@map_id]['pxWid'],
							h: @parse_map['levels'][@map_id]['pxHei']
		}
		@number_of_levels = @parse_map['levels'].length
		@sprites = load_sprites args
		@walls = load_walls args
		@defaults = load_defaults args
		@exit = get_exit
		@doors = get_doors
		@switches = get_switches
	end	

	def load_sprites args
		new_sprites = Array.new
	  @parse_map['levels'][@map_id]['layerInstances'][2]['gridTiles'].each do |ln|
	  	building_sprite = { x: ln['px'][0],
                       y: (@size.h - 16) - ln['px'][1],
                       w: 16,
                       h: 16,
                       path: @parse_map['levels'][@map_id]['layerInstances'][2]['__tilesetRelPath'].delete_prefix('../'),
                       tile_x: ln['src'][0],
                       tile_y: ln['src'][1],
                       tile_w: 16,
                       tile_h: 16,
                       flip_horizontally: false,
                       flip_vertically: false
                       }
      building_sprite.flip_horizontally = true if ln['f'] == 1 or ln['f'] == 3
      building_sprite.flip_vertically = true if ln['f'] == 2 or ln['f'] == 3
      
    	new_sprites << building_sprite
	  end
	  return new_sprites
	end

	def load_walls args
		new_walls = Array.new
		rows = (@size.h / 16).to_i
    cols = (@size.w / 16).to_i
  	rows.times do |y_new|
	  cols.times do |x_new|
	    new_index = y_new * 16 + x_new
	    if @parse_map['levels'][@map_id]['layerInstances'][0]['intGridCsv'][new_index] == 1
	    new_walls << { x: x_new * 16,
                     y: (@size.h - 16) - (y_new * 16),
                     w: 16,
                     h: 16,
                    id: 'w'}
	    end
	  end
  	end
	  return new_walls
 	end

 	def load_defaults args
 		defaults = Array.new
 		@parse_map['levels'][@map_id]['layerInstances'][1]['entityInstances'].each { |e| defaults << e }
		return defaults
 	end

 	def player_start
 		player_start_pos = @defaults.select {|e| e['__identifier'] == 'Player'}
 		return {x: player_start_pos[0]['px'][0], y: (@size.h - 16) - player_start_pos[0]['px'][1]}
	end

	def enemies_list
		enemies_start_pos = @defaults.select {|e| e['__identifier'] == 'Enemy'}
		enemies_list = Array.new
		enemies_start_pos.each do |e|
			enemies_list << {x: e['px'][0], y: (@size.h - 16) - e['px'][1], type: e['fieldInstances'][0]['__value'] }
		end
		return enemies_list
	end

	def get_exit
		exit_pos = @defaults.select {|e| e['__identifier'] == 'Exit'}
		return {x: exit_pos[0]['px'][0], y: (@size.h - 16) - exit_pos[0]['px'][1], w: 16, h:16 }
	end

	def get_doors
	  doors_parse = @defaults.select {|e| e['__identifier'] == 'Door'}
    doors_list = Array.new
    doors_parse.each do |door|
      new_door = { x: door['px'][0], y: (@size.h - 16) - door['px'][1], w: 16, h: 16 }
      doors_list << Door.new(new_door, door['iid'])
    end
    return doors_list
	end

	def get_switches
	  switches_parse = @defaults.select {|e| e['__identifier'] == 'Switch'}
	  switches_list = Array.new
	  switches_parse.each do |switch|
	    new_switch = { x: switch['px'][0], y: (@size.h - 16) - switch['px'][1], w: 16, h: 16 }
	    link = switch['fieldInstances'][0]['__value']['entityIid']
	    switches_list << Switch.new(new_switch, link)
	  end
	  return switches_list
	end

  def chests_list
    chests_parse = @defaults.select { |e| e['__identifier'] == 'Destroy'}
    chests_list = Array.new
    chests_parse.each do |chest|
      new_chest = { x: chest['px'][0], y: (@size.h - 16) - chest['px'][1], w: 16, h: 16, has_item: chest['fieldInstances'][0]['__value'], type: chest['fieldInstances'][1]['__value'] }
      chests_list << new_chest
    end
    return chests_list
  end

	def exit? args
	return true if @exit.intersect_rect? args.state.player
	end
end

class Enemy
	attr_gtk
	attr_rect
	attr :pos, :x, :y, :w, :h, :is_dead

	def initialize pos, type
	@x = pos.x
	@y = pos.y
	@w = 16
	@h = 16
	@direction = type
	@vector = {x: 16, y: 0}
	@prev_vector = {x: 0, y: 0}
	@cooldown = 16
	@is_dead = false
	@player_inside = false
	@collision_counter = 0
	end

	def move args
		if @cooldown <= 0
		motion args
		@cooldown = 8
		end
		args.outputs.debug << "#{(check_motions args).length}"
		@cooldown -= 0.8
 	end

  def motion args
  	case @direction

			when 'H'
				@vector.x = @vector.x * -1 if collision? @vector, args
				@x += @vector.x
				
			when 'V'
				@vector.y = @vector.y * -1 if collision? @vector, args
				@x += @vector.y

			when 'D'
			possible_vectors = check_motions args

			if possible_vectors.length > 1 and rand(20) > 16 #chance de que se mueva a una posicion abierta
				new_vector = possible_vectors.sample
				@vector = new_vector
			end
			if collision? @vector, args
				new_vector = possible_vectors.sample
				@vector = new_vector
			end
			@x += @vector.x
			@y += @vector.y
  	end
  end

  def check_motions args
		motions = [
			{ x: 16, y: 0 },
			{ x: -16, y: 0 },
			{ x: 0, y: 16 },
			{ x: 0, y: -16 }
		]
		motions.reject! { |motion| collision? motion, args}
		if motions.length > 1
		inverted_vector = { x: @vector.x * -1, y: @vector.y * -1}
		motions.reject! { |motion| motion == inverted_vector}
		end
		return motions
  end

	def player_spotted? args
	#spot_rect = { x: @x - 32, y: @y - 32, w: 80, h: 80 }
	spot_rect = { x: @x - 48, y: @y - 48, w: 112, h: 112 }
	return true if args.state.player.inside_rect? spot_rect
	end

 	def collision? new_position, args
 	new_position = { x: @x + new_position.x,
                   y: @y + new_position.y,
                   h: @h,
                   w: @w
 	    }
  check_doors = args.state.world.doors.select {|door| !door.is_open}
 	if args.state.world.walls.any_intersect_rect? new_position or args.state.seeds.any_intersect_rect? new_position or check_doors.any_intersect_rect? new_position or args.state.world.exit.intersect_rect? new_position or args.state.chests.any_intersect_rect? new_position #or args.state.player.intersect_rect? new_position
	@collision_counter += 1
	return true
 	end
 	end

  def check_hit args
  	current = {x: @x, y: @y, w: @w, h: @h}
	  args.state.germinations.each do |germination|
	  	if germination.has_started
		 		if germination.pos.intersect_rect? current
        args.outputs.sounds << "sounds/enemy_hit.wav"
        args.state.player.score += 500
				@is_dead = true
		 		end
	 		end
  	end	
  end
  
end


class Player
	attr_gtk
	attr_rect
	attr :pos, :x, :y, :w, :h, :carry, :plant_cooldown, :is_dead, :reloading_seed, :has_planted, :carry, :reload_factor, :score

	def initialize pos
	@x = pos.x
	@y = pos.y
	@w = pos.w
	@h = pos.h
	@carry = false
	@has_planted = false
	@plant_cooldown = 120
	@is_dead = false
	@reloading_seed = @plant_cooldown
	@reload_factor = 1
	@score = 0
	end
	
	def move args
		step = 16
    args.state.mover_timer ||= 0
    if args.state.mover_timer <= 0
      new_position = { x: @x,
                       y: @y,
                       h: @h,
                       w: @w
    }
      moved = false
      if args.inputs.keyboard.key_held.up
        new_position.y += step
        @y += step unless collisions? args, new_position
        moved = true
      end
      if args.inputs.keyboard.key_held.down
        new_position.y -= step
        @y -= step unless collisions? args, new_position 
        moved = true
      end
      if args.inputs.keyboard.key_held.left
        new_position.x -= step
        @x -= step unless collisions? args, new_position
        moved = true
      end
      if args.inputs.keyboard.key_held.right
        new_position.x += step
        @x += step unless collisions? args, new_position
        moved = true 
      end
    end
    args.state.mover_timer = 8 if moved
    args.state.mover_timer -= 0.8
  end

  def collisions? args, new_position
  check_doors = args.state.world.doors.select {|door| !door.is_open}
  return true if args.state.world.walls.any_intersect_rect? new_position or args.state.seeds.any_intersect_rect? new_position or check_doors.any_intersect_rect? new_position or args.state.chests.any_intersect_rect? new_position #or args.state.enemies.any_intersect_rect? new_position
  end

  def item_pickup? args
  current_position = { x: @x, y: @y, h: @h, w: @w }
  item_selected = args.state.items.find { |item| item.intersect_rect? current_position}
  args.outputs.debug << "#{item_selected.type}" if item_selected != nil
  if item_selected
    case item_selected.type
    when "Seed"
    if @reload_factor <= 4
    @reload_factor += 1
    end
    @score += 100
    when "Coin"
    @score += 10
    end
    item_selected.pick_up
  end
  end

  def action args
  	if @has_planted == false and !collisions?(args, {x: @x, y: @y, h: @h, w: @w})
	    if args.keyboard.key_held.z
	    args.outputs.debug << "z pressed"
	    @carry = true
	    end
	    if args.keyboard.key_up.z
	    args.outputs.sounds << "sounds/plant.wav"
	    @carry = false
	    @has_planted = true
	    @reloading_seed = 0
      @when_planted = Kernel.tick_count
	    new_seed = {x: @x, y: @y, w: 16, h:16}
	    args.state.seeds << Seed.new(new_seed, args.state.current_shape.dup)
	    end
    end
    if @has_planted == true and @reloading_seed <= @plant_cooldown
     	@reloading_seed += @reload_factor * 2
    	@reloading_seed = @reloading_seed.clamp(0, @plant_cooldown)
    end
    if @reloading_seed >= @plant_cooldown and @has_planted == true
	    args.state.current_shape = set_shape args
			@has_planted = false
    end
  end
end

class Seed
  attr_gtk
  attr_rect
  attr :is_dead, :x, :y, :w, :h
  	
  def initialize pos, shape
  @x = pos.x
  @y = pos.y
  @w = pos.w
  @h = pos.h
  @stored_shape = shape
  @is_dead = false
  @counter = 60
  end

  def germinate args
  @counter -= 1
  args.outputs.debug << "germinando"
		if @counter <= 0
			base_germination = {x: @x, y: @y, w: @w, h: @h}
      if !args.state.world.switches.any_intersect_rect? base_germination #version si se planta en el suelo
      args.outputs.sounds << "sounds/germination.wav"
			args.state.germinations << Germination.new(base_germination, 0)
  			@stored_shape.each do |shape|
  				new_shape = {x: @x + shape.x, y: @y + shape.y, w: @w, h: @h}
  				args.state.germinations << Germination.new(new_shape, 10)
  			  end
  		elsif args.state.world.switches.any_intersect_rect? base_germination #version si se planta sobre un interruptor
  		find_switch = args.state.world.switches.find {|switch| intersect_rect? switch, base_germination}
  		find_switch.use args
  		args.outputs.debug << "#{find_switch.link}"
			end
			@is_dead = true
		end
  end

  def sprite
      sprite = { x: @x, y: @y, w: @w, h: @h, path: '/sprites/seed.png' }
      return sprite
  end
  
  
end

class Germination
	attr_gtk
	attr_rect
	attr :pos, :is_dead, :has_started
	
	def initialize pos, pre_count	
	@pos_buffer = pos
	@time_to_appear = pre_count
	@time_when_created = Kernel.tick_count
	@has_started = false
	@pos = nil
	@time_when_started = nil
	@is_dead = false
	end

	def set_up args
		if Kernel.tick_count - @time_when_created >= @time_to_appear and !@has_started
			if !args.state.world.walls.any_intersect_rect? @pos_buffer 
				@pos = @pos_buffer
				@x = @pos.x
				@y = @pos.y
				@h = @pos.h
				@w = @pos.w
				@time_when_started = Kernel.tick_count
				@has_started = true
			else
				@is_dead = true
			end
		end
	end

	def banish args
		if @has_started
			if Kernel.tick_count - @time_when_started >= 20
				@is_dead = true
			end
		end
	end

	def sprite
    if @has_started
      sprite = { x: @pos.x, y: @pos.y, w: @pos.w, h: @pos.h }
      if Kernel.tick_count - @time_when_started <= 2
      sprite.path = '/sprites/spike/1.png'
      elsif Kernel.tick_count - @time_when_started <= 4
      sprite.path = '/sprites/spike/2.png'
      elsif Kernel.tick_count - @time_when_started <= 6
      sprite.path = '/sprites/spike/3.png'
      else
      sprite.path = '/sprites/spike/4.png'
      end
      return sprite
    end
	end
	
end

class Door
  attr_gtk
  attr_rect
  attr :link, :is_open, :x, :y, :w, :h

  def initialize pos, link
  @x = pos.x
  @y = pos.y
  @w = pos.w
  @h = pos.h
  @link = link
  @is_open = false
  end

  def open
  @is_open = true
  end

  def sprite
	  case @is_open
	  when false
    sprite = { x: @x, y: @y, w: @w, h: @h, path: "/sprites/door_close.png" }
	  when true
    sprite = { x: @x, y: @y, w: @w, h: @h, path: "/sprites/door_open.png" }
	  end
  end
  
end

class Switch
  attr_gtk
  attr_rect
  attr :link, :was_used, :x, :y, :w, :h

  def initialize pos, link
  @x = pos.x
  @y = pos.y
  @w = pos.w
  @h = pos.h
  @link = link
  @was_used = false
  end

  def use args
	  door_to_open = args.state.world.doors.find {|door| door.link == @link}
	  door_to_open.open
	  args.state.player.score += 1000
	  @was_used = true
  end

  def sprite
  	case @was_used
  	when false
    sprite = { x: @x, y: @y, w: @w, h: @h, path: "/sprites/switch_off.png" }
    when true
    sprite = { x: @x, y: @y, w: @w, h: @h, path: "/sprites/switch_on.png" }
	  end
  end
  
end

class Chest
  attr_gtk
  attr_rect
  attr :x, :y, :w, :h, :is_dead

  def initialize pos
    @x = pos.x
    @y = pos.y
    @w = pos.h
    @h = pos.h
    @has_item = pos.has_item
    @item_contained = pos.type
    @is_dead = false
  end

  def check_hit args
  	current = {x: @x, y: @y, w: @w, h: @h}
	  args.state.germinations.each do |germination|
	  	if germination.has_started
		 		if germination.pos.intersect_rect? current
		 		args.state.items << Item.new(current, @item_contained) if @has_item
		 		args.state.player.score += 50
				@is_dead = true
		 		end
	 		end
  	end	
  end

  def sprite
    sprite = { x: @x, y: @y, w: @w, h: @h, path: '/sprites/chest.png'
               }
  end
end

class Item
  attr_gtk
  attr_rect
  attr :x, :y, :w, :h, :picked_up, :type

  def initialize pos, type
    @x = pos.x
    @y = pos.y
    @w = pos.w
    @h = pos.h
    @type = type
    @picked_up = false
  end

  def pick_up
    @picked_up = true
  end

  def sprite
    case @type
    
    when "Seed"
    sprite = { x: @x, y: @y, w: @w, h: @h, path: '/sprites/seed.png' }
    when "Coin"
    sprite = { x: @x, y: @y, w: @w, h: @h, path: '/sprites/coin.png' }
    end
                  
  end
  
end

#-----------------------------------------------------------
#FUNCIONES DE AYUDA
def set_shape args
  shape_cross = [ #horizontal y vertical
#lvl1
									{x: 0, y: 16, lvl: 1},
									{x: 0, y: -16, lvl: 1},
									{x: 16, y: 0, lvl: 1},
									{x: -16, y: 0, lvl: 1}]
# #lvl2
#                   {x: 0, y: 32, lvl: 2},
# 									{x: 0, y: -32, lvl: 2},
# 									{x: 32, y: 0, lvl: 2},
# 									{x: -32, y: 0, lvl: 2},
# #lvl3
#                   {x: 0, y: 48, lvl: 3},
# 									{x: 0, y: -48, lvl: 3},
# 									{x: 48, y: 0, lvl: 3},
# 									{x: -48, y: 0, lvl: 3}
#   ]
  
    
  shape_x = [ #diagonales
									{x: -16, y: -16},
									{x: -16, y: 16},
									{x: 16, y: -16},
									{x: 16, y: 16}
	]
	shape_vertical = [
									{x: 0, y: 16},
									{x: 0, y: -16}
	]
	shape_horizontal = [
									{x: 16, y: 0},
									{x: -16, y: 0}
	]
  shape_mega = [ #horizontal y vertical
									{x: 0, y: 16},
									{x: 0, y: -16},
									{x: 16, y: 0},
									{x: -16, y: 0},
									{x: -16, y: -16},
									{x: -16, y: 16},
									{x: 16, y: -16},
									{x: 16, y: 16}
  ]
	shape_t = shape_cross.dup
	shape_t.delete_at(rand(4))
	shape_options = [shape_cross, 
	              shape_x,
	              shape_vertical, 
	              shape_horizontal, 
	              shape_t]
  shape_options.reject! {|shape| shape == args.state.current_shape}
	new_pattern = shape_options.sample
	#new_pattern = shape_cross
	return new_pattern
end


def render args
  args.outputs.solids << { x: 0, y: 0, w: 1280, h: 720 } #fondo negro
	#graficos del hud
	#args.outputs[:hud].sprites << {x: 0, y: 0, w: 5, h: 720, r: 255, g: 255, b: 255}
	#args.outputs[:hud].sprites << {x: 15, y: 0, w: 5, h: 720, r: 255, g: 255, b: 255}
  args.outputs[:hud].borders << { x: 100, y: 150, w: 320, h: 420, r: 255, g: 255, b: 255 }
  args.outputs[:hud].borders << { x: 90, y: 140, w: 340, h: 440, r: 255, g: 255, b: 255 }
	args.outputs[:hud].sprites << {x: 135, y: 400, w: 100, h: 150, path: "sprites/chara.png"}

	args.outputs[:hud].sprites << {x: 255, y: 510, w: 32, h: 32, path: "sprites/seed.png"}
	args.state.player.reload_factor.times do |i|
	args.outputs[:hud].sprites << {x: 295 + (i*20), y: 518, w: 18, h: 18, path: "sprites/star.png"}
	end
	
	args.outputs[:hud].sprites << {x: 255, y: 460, w: 32, h: 32, path: "sprites/ghost.png"}
	args.outputs[:hud].labels << {x: 365, y: 495, size_enum: 8, alignment_enum: 2, text: "x #{args.state.enemies.length}", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf"}
	
	args.outputs[:hud].labels << {x: 305, y: 455, size_enum: 3, alignment_enum: 2, text: "PUNTOS", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf"}
	args.outputs[:hud].labels << {x: 365, y: 435, size_enum: 8, alignment_enum: 2, text: "#{args.state.player.score}", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf"}

	args.outputs[:hud].sprites << {x: 170,
																 y: 465,
																 w: 30,
																 h: (args.state.player.reloading_seed * 45 / args.state.player.plant_cooldown), r: 0, g: 0, b:0 }
  args.outputs[:hud].solids << {x: 240, y: 250, w: 40, h: 40, r: 255, g: 255, b: 255 }
	args.state.current_shape.each do |shape|
  args.outputs[:hud].solids << {x: 240 + (shape.x*3), y: 250 + (shape.y*3), w: 40, h: 40,
  															r: 255, g: 255, b: 255}
	end
															  
	#graficos del nivel
	args.state.world.sprites.each { |tile| args.outputs[:scene].sprites << tile }
	args.state.world.doors.each { |door| args.outputs[:scene].sprites << door.sprite }
  args.state.world.switches.each { |switch| args.outputs[:scene].sprites << switch.sprite }
	args.state.seeds.each do |seed|
		args.outputs[:scene].sprites << seed.sprite
	end
	args.state.germinations.each do |germination|
		if germination.has_started
			args.outputs[:scene].sprites << germination.sprite
		end
	end
	args.state.enemies.each do |enemy|
		args.outputs[:scene].sprites << { x: enemy.x,
																		  y: enemy.y,
																		  w: 16,
																		  h: 16,
																		  path: 'sprites/ghost.png'
		}
	end
	args.outputs[:scene].sprites << { x: args.state.world.exit.x, y: args.state.world.exit.y, w: args.state.world.exit.w, h: args.state.world.exit.h, path: "sprites/exit_open.png" } if args.state.enemies.length <= 0
	args.outputs[:scene].sprites << { x: args.state.world.exit.x, y: args.state.world.exit.y, w: args.state.world.exit.w, h: args.state.world.exit.h, path: "sprites/exit_close.png" } if args.state.enemies.length > 0

	if args.state.player.carry
  	args.state.current_shape.each do |shape|
  	  args.outputs[:scene].sprites << {
  	                           x: args.state.player.x + shape.x,
  	                           y: args.state.player.y + shape.y,
  	                           w: 16,
  	                           h: 16,
  	                           path: "sprites/marker.png"
  	  }
  	end
	end

  args.state.chests.each { |chest| args.outputs[:scene].sprites << chest.sprite }
  args.state.items.each { |item| args.outputs[:scene].sprites << item.sprite }

	args.outputs[:scene].sprites << {
	                           x: args.state.player.x,
	                           y: args.state.player.y,
	                           w: args.state.player.w,
	                           h: args.state.player.h,
	                           path: 'sprites/chara.png'
	  }
	if args.state.player.carry
  	args.outputs[:scene].sprites << {
  	                           x: args.state.player.x+5,
  	                           y: args.state.player.y+7,
  	                           w: 6,
  	                           h: 5,
  	                           r: 0, g: 0, b: 0
  	  }
	end

  args.outputs.sprites << { x: 64,
                            y: draw_camera(args),
                            w: args.grid.w*3,
                            h: args.grid.h*3,
                            path: :scene
  }
	args.outputs.sprites << { x: 810,
														y: 0,
														w: 1280,
														h: 720,
														path: :hud}
end

def draw_camera args
	if args.state.world.size.h == 256
	args.state.camera.next_y = (args.state.world.size.h/4) - args.state.player.y
  easing = 0.2
	elsif args.state.world.size.h == 320
	args.state.camera.next_y = (args.state.world.size.h/4) - args.state.player.y * 1.2
  easing = 0.2
	elsif args.state.world.size.h == 512
	args.state.camera.next_y = (args.state.world.size.h/4) - args.state.player.y * 2	
  easing = 0.05
	end
	
  args.state.camera.changing ||= false


  if args.state.camera.prev_y != args.state.camera.next_y
    args.state.camera.changing = true
  end

  if args.state.camera.changing == true
  difference = args.state.camera.next_y - args.state.camera.prev_y
  args.state.camera.prev_y += difference * easing
    if difference.abs < easing
    args.state.camera.prev_y = args.state.camera.next_y
    args.state.camera.changing = false
    end
  end
    
  return args.state.camera.prev_y
end

def build_world args
	if !args.state.loaded
  	args.state.world = World.new args, args.state.current_level
  	args.state.player.x = args.state.world.player_start.x
  	args.state.player.y = args.state.world.player_start.y
    args.state.player.reload_factor = args.state.stats.reload_factor
    args.state.player.score = args.state.stats.score
	  args.state.player.reloading_seed = args.state.player.plant_cooldown
  	args.state.enemies = Array.new
  	args.state.world.enemies_list.each do |e|
    	new_enemy = {x: e.x, y: e.y, w: 16, h: 16 }
    	type = e.type
    	args.state.enemies << Enemy.new(new_enemy, type)
    	end
  	args.state.seeds = Array.new
  	args.state.germinations = Array.new
  	args.state.chests = Array.new
  	args.state.world.chests_list.each do |chest|
      args.state.chests << Chest.new(chest)
  	  end
  	args.state.items = Array.new
  	args.state.current_shape = set_shape args

  	#cargar camara inicial para el nuevo mundo
  	if args.state.world.size.h == 256
    args.state.camera.prev_y = (args.state.world.size.h/4) - args.state.player.y
  	elsif args.state.world.size.h == 320
    args.state.camera.prev_y = (args.state.world.size.h/4) - args.state.player.y * 1.2
  	elsif args.state.world.size.h == 512
    args.state.camera.prev_y = (args.state.world.size.h/4) - args.state.player.y * 2
		end
						
  	args.state.loaded = true
  	args.state.player.has_planted = false
		args.state.player.carry = false
  	args.state.changing = false
	end
end

def check_player args
    current_position = { x: args.state.player.x, y: args.state.player.y, h: args.state.player.h, w: args.state.player.w }

  args.state.germinations.each do |germination|
    if germination.has_started
      if germination.pos.intersect_rect? current_position
        args.outputs.sounds << "sounds/player_hit.wav"
        args.state.reload_timer = Kernel.tick_count
        args.state.changing = true
	      args.state.stats.reload_factor = 1
      end
    end
  end

  args.state.enemies.each do |enemy|
    if enemy.intersect_rect? current_position
    args.outputs.sounds << "sounds/player_hit.wav"
    args.state.reload_timer = Kernel.tick_count
    args.state.changing = true
    args.state.stats.reload_factor = 1
    end
  end
end

def transition args
  args.outputs.debug << "current #{Kernel.tick_count - args.state.reload_timer}"
  
  grade = Kernel.tick_count - args.state.reload_timer
  #args.outputs.sprites << { x: 0, y: 0, w: 1280, h: 720, r: 0, g: 0, b: 0 }
  if Kernel.tick_count - args.state.reload_timer > 20
    args.state.next_scene = :over_scene
  end
end

def tick_title_scene args
  args.outputs.solids << { x: 0, y: 0, w: 1280, h: 720 } #fondo negro
  if Kernel.tick_count == 0
  #args.audio[:menu] = { input: "sounds/main_menu.wav", gain: 0.3}
  end

	args.state.main_menu ||= 0
	args.state.showing_instructions ||= false

	if args.state.showing_instructions == false
		#render titulo y opciones
	  args.outputs.sprites << { x: args.grid.w/4, y: args.grid.h-300, w: 592, h: 128, path: 'sprites/title/logo.png'}
		args.outputs.labels << { x: args.grid.w/2 - 60, y: 350, size_enum: 4, size_enum: 8, text: "Empezar", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf" }
		args.outputs.labels << { x: args.grid.w/2 - 60, y: 300, size_enum: 4, size_enum: 8, text: "Cómo se juega", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf" }
		

		#mostrar la flechita del menu principal
		if args.state.main_menu == 0
		args.outputs.labels << { x: args.grid.w/2 - 80, y: 350, size_enum: 4, size_enum: 8, text: ">", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf" }
		else
		args.outputs.labels << { x: args.grid.w/2 - 80, y: 300, size_enum: 4, size_enum: 8, text: ">", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf" }
		end
	end
	
	if args.inputs.keyboard.key_up.down and args.state.showing_instructions == false
		args.state.main_menu += 1
		if args.state.main_menu > 1
		args.state.main_menu = 0
		end
	end
	if args.inputs.keyboard.key_up.up and args.state.showing_instructions == false
		args.state.main_menu -= 1
		if args.state.main_menu < 0
		args.state.main_menu = 1
		end
	end
	
  if args.inputs.keyboard.key_down.enter and args.state.main_menu == 0 and args.state.showing_instructions == false
    args.audio[:menu] = nil
    args.state.next_scene = :loading_scene
  end  
  if args.inputs.keyboard.key_down.enter and args.state.main_menu == 1 and args.state.showing_instructions == false
    args.state.showing_instructions = true
    args.state.menu_pressed = Kernel.tick_count
  end

	if args.state.showing_instructions == true
	args.outputs.sprites << { x: 300, y: 100, w: 640, h: 480, path: "sprites/title/instructions.png"}
	args.outputs.labels << { x: 630, y: 500, size_enum: 4, size_enum: 8, text: "Moverse", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf" }
	args.outputs.labels << { x: 630, y: 430, size_enum: 4, size_enum: 8, text: "Plantar semilla", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf" }
	
	end
	if args.inputs.keyboard.key_down.enter and args.state.showing_instructions == true and Kernel.tick_count - args.state.menu_pressed > 10
		args.state.showing_instructions = false
	end
  
end


def tick_over_scene args
    args.outputs.solids << { x: 0, y: 0, w: 1280, h: 720 } #fondo negro  
    args.state.next_scene = :game_scene
    #args.state.current_level = 0
    args.state.loaded = false
    build_world args
end

def tick_loading_scene args
    args.outputs.solids << { x: 0, y: 0, w: 1280, h: 720 } #fondo negro  
    args.outputs.sprites << { x: 200, y: 150, w: 480, h: 480, path: "sprites/title/title_art.png" }

		args.state.text_prog ||= ""
#		text_full = "Con una semilla germinando en su interior el muchacho se adentra en la dimensión del Musgo para purgar a los espectros del Odio..."
		text_full = "En la dimensión donde ya nada puede germinar, un muchacho que porta una semilla en su interior se adentra para purgar a los espectros de la Tierra Muerta..."

		if Kernel.tick_count.zmod?(2) and args.state.text_prog.length <= text_full.length
			args.state.text_prog = text_full[0, args.state.text_prog.length + 1]
			args.audio[:text] = { input: "sounds/text.wav", gain: 0.3}
		end 

		if args.state.text_prog.length >= text_full.length
			args.audio[:text] = nil
		end
		
	 	split_text = String.wrapped_lines args.state.text_prog, 30

		 split_text.map_with_index do |s, i|
			args.outputs.labels << { x: 700, y: 520-60, size_enum: 8, anchor_y: i, text: s, r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf" }
		 end

		if args.state.text_prog.length >= text_full.length
		args.outputs.labels << { x: 700, y: 250, size_enum: 4, text: "> Enter para jugar <", r: 255, g: 255, b: 255, font: "fonts/Orange Kid.otf" }
		end
    
    if args.inputs.keyboard.key_down.enter and args.state.text_prog.length >= text_full.length
    args.state.next_scene = :game_scene
    end
end

def tick_ending_scene args
    args.outputs.solids << { x: 0, y: 0, w: 1280, h: 720, r:255, g: 0, b: 0 } #fondo negro  
    if args.inputs.keyboard.key_down.enter
    	$gtk.reset
    end
end

#LOGICA PRINCIPAL
#--------------------------------------------
def tick args
  args.state.current_scene ||= :title_scene
  current_scene = args.state.current_scene
  if args.state.current_scene != current_scene
    raise 'viva peron'
  end
  
  case current_scene
  when :title_scene
  tick_title_scene args
  when :over_scene
  tick_over_scene args
  when :loading_scene
  tick_loading_scene args
  when :ending_scene
  tick_ending_scene args
  when :game_scene
	args.state.current_level ||= 0
	args.state.loaded ||= false
	args.state.player ||= Player.new({ x: 0, y: 0, w: 16, h: 16 })
  args.state.stats ||= { reload_factor: args.state.player.reload_factor, score: args.state.player.score }
	build_world args
	#calcular interacciones. changing false para asegurarse que no esté cargandose la pantalla si habíamos previamente perdido.
  if args.state.changing == false
    #PASO 1: resolver la logica de cada objeto, mover al jugador, enemigos, generar y eliminar semillas, espinas, chequear objetos etc
    args.state.player.move args
    args.state.player.item_pickup? args
    args.state.player.action args
    args.state.items.reject! {|e| e.picked_up}
    args.state.enemies.each {|e| e.move args}
  	args.state.seeds.each {|e| e.germinate args}
  	args.state.seeds.reject! {|e| e.is_dead}
  	args.state.germinations.each {|e| e.set_up args}
  	args.state.enemies.each {|e| e.check_hit args}
  	args.state.enemies.reject! {|e| e.is_dead}
  	args.state.chests.each {|e| e.check_hit args}
  	args.state.chests.reject! {|e| e.is_dead}
  	args.state.germinations.each {|e| e.banish args}
  	args.state.germinations.reject! {|e| e.is_dead}
    #PASO 2: revisar si se tocó la salida (lo hace el main loop porque no me salió de otra menra)
    	if args.state.world.exit? args and args.state.enemies.length <= 0
    	args.outputs.debug << 'salida tocada'
    	args.state.current_level += 1
    	#args.state.current_level = 0 if args.state.current_level >= args.state.world.number_of_levels
			if args.state.current_level >= 0
				args.state.next_scene = :ending_scene
			end
    	args.outputs.sounds << "sounds/next_level.wav"
    	args.state.loaded = false
      args.state.stats = { reload_factor: args.state.player.reload_factor, score: args.state.player.score }
    	build_world args
    	end
    #PASO 3: revisar si el jugador tocó a un enemigo o alguna espina (de la misma manera, se revisa acá porque sino no funcionaba bien)
    check_player args
  end #fin de todos los casos para cada escena

	#render
	render args

  if args.state.changing == true
  transition args
  end
	

	#debug  
  args.outputs.debug << "map size #{args.state.world.size.w}, #{args.state.world.size.h}"
  args.outputs.debug << "player x: #{args.state.player.x} y: #{args.state.player.y}"
	args.outputs.debug << "paredes #{args.state.world.walls.size}"
	args.outputs.debug << "reacarga #{args.state.player.reloading_seed}"
	
  end

  #se poen en nil cosa que se active cada vez que se haya seteado a algo nuevo
  if args.state.next_scene != nil
    args.state.current_scene = args.state.next_scene
    args.state.next_scene = nil 
  end
end

$gtk.reset
